//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "MMLEDS"
#pragma link "MMObj"
#pragma link "MMSpectr"
#pragma link "MMDIBCv"
#pragma link "MMLevel"
#pragma link "MMSwitch"
#pragma link "MMWavIn"
#pragma link "MMDSPObj"
#pragma link "MMConect"
#pragma link "MMDesign"
#pragma link "MMHook"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::StartButtonClick(TObject *Sender)
{
     if (MMWaveIn1->Numdevs == 0)
          Application->MessageBox("Sorry, No WaveIn device installed!",
                                  "WaveIn open error",MB_OK || MB_ICONSTOP);
     else
        MMWaveIn1->Start();

}
//---------------------------------------------------------------------------
void __fastcall TForm1::StopButtonClick(TObject *Sender)
{
     MMWaveIn1->Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ExitButtonClick(TObject *Sender)
{
     Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ckBLogFreqClick(TObject *Sender)
{
   MMSpectrum1->LogFreq = ckBLogFreq->Checked;
   MMSpectrum2->LogFreq = ckBLogFreq->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ckBLogAmpClick(TObject *Sender)
{
   MMSpectrum1->LogAmp = ckBLogAmp->Checked;
   MMSpectrum2->LogAmp = ckBLogAmp->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMSwitch1Change(TObject *Sender)
{
   MMSpectrum1->Kind = TMMSpectrumKind(MMSwitch1->Position);
   MMSpectrum2->Kind = TMMSpectrumKind(MMSwitch1->Position);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMLEDSpin2UpClick(TObject *Sender)
{
   MMSpectrum1->FFTLength = MMSpectrum1->FFTLength * 2;
   MMSpectrum2->FFTLength = MMSpectrum2->FFTLength * 2;
   MMLEDSpin2->Value = MMSpectrum1->FFTLength;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMLEDSpin2DownClick(TObject *Sender)
{
   MMSpectrum1->FFTLength = MMSpectrum1->FFTLength / 2;
   MMSpectrum2->FFTLength = MMSpectrum2->FFTLength / 2;
   MMLEDSpin2->Value = MMSpectrum1->FFTLength;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMSwitch2Change(TObject *Sender)
{
   MMSpectrum1->Window = TMMFFTWindow(MMSwitch2->Position);
   MMSpectrum2->Window = TMMFFTWindow(MMSwitch2->Position);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::MMSwitch3Change(TObject *Sender)
{
   MMSpectrum1->DecayMode = TMMDecayMode(MMSwitch3->Position);
   MMSpectrum2->DecayMode = TMMDecayMode(MMSwitch3->Position);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::MMLEDSpin1Change(TObject *Sender)
{
   MMSpectrum1->Decay = MMLEDSpin1->Value;
   MMSpectrum2->Decay = MMLEDSpin1->Value;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ckBDrawScaleClick(TObject *Sender)
{
   MMSpectrum1->DrawAmpScale  = ckBDrawScale->Checked;
   MMSpectrum1->DrawFreqScale = ckBDrawScale->Checked;
   MMSpectrum2->DrawAmpScale  = ckBDrawScale->Checked;
   MMSpectrum2->DrawFreqScale = ckBDrawScale->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMLEDSpin3UpClick(TObject *Sender)
{
   int Factor;

   if (MMSpectrum1->VerticalScale < 10)
       Factor = 1;
   else
       Factor = 10;

   MMSpectrum1->VerticalScale = MMSpectrum1->VerticalScale + Factor;
   MMSpectrum2->VerticalScale = MMSpectrum2->VerticalScale + Factor;
   MMLEDSpin3->Value = MMSpectrum1->VerticalScale;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMLEDSpin3DownClick(TObject *Sender)
{
   int Factor;

   if (MMSpectrum1->VerticalScale > 10)
       Factor = 10;
   else
       Factor = 1;

   MMSpectrum1->VerticalScale = MMSpectrum1->VerticalScale - Factor;
   MMSpectrum2->VerticalScale = MMSpectrum2->VerticalScale - Factor;
   MMLEDSpin3->Value = MMSpectrum1->VerticalScale;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
   Overflow = False;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
   Timer1->Enabled = False;
   MMWaveIn1->Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMSwitch4Change(TObject *Sender)
{
   MMSpectrum1->Gain = TMMSpectrumGain(MMSwitch4->Position);
   MMSpectrum2->Gain = TMMSpectrumGain(MMSwitch4->Position);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMConnector1Trigger(TObject *Sender)
{
   if (Overflow)
   {
      MMLED1->Enabled = False;
      MMLED2->Enabled = False;
      MMLED3->Enabled = False;
      MMLED4->Enabled = False;
      Overflow = False;
   }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
   TPeak aPeak;
   Long Temp;

     if ((ckBFrames->Checked) && (MMConnector1->RefreshCountSpectrum != OldRefreshCount))
     {
        Temp = MMConnector1->RefreshCountSpectrum;
        ckBFrames->Caption = " " + IntToStr(Temp) + " frames/s";
        OldRefreshCount = Temp;
     };
     MMConnector1->RefreshCountSpectrum = 0;

     if (ckBPeak->Checked)
     {
        aPeak = MMSpectrum1->Peak;
       // lblPeak->Caption = Format(" Frequency: %7.1f Hz ",[aPeak->Freq])+
       //                    Format(" Amplitude: %7.5f ",[aPeak->Amp])+
       //                    Format(" %7.2f db ",[aPeak->db]);
     }
     else lblPeak->Caption = "---";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMSpectrum1PcmOverflow(TObject *Sender)
{
     Overflow = True;
     if (Sender == MMSpectrum1)
     	 MMLED1->Enabled = True;
     else
         MMLED3->Enabled = True;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMSpectrum1GainOverflow(TObject *Sender)
{
     Overflow = True;
     if (Sender == MMSpectrum1)
         MMLED2->Enabled = True;
     else
         MMLED4->Enabled = True;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ckBGridClick(TObject *Sender)
{
   MMSpectrum1->DrawGrid = ckBGrid->Checked;
   MMSpectrum2->DrawGrid = ckBGrid->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMLEDSpin4Change(TObject *Sender)
{
   MMSpectrum1->PeakDelay = MMLEDSpin4->Value;
   MMSpectrum2->PeakDelay = MMLEDSpin4->Value;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMLEDSpin8Change(TObject *Sender)
{
   MMSpectrum1->PeakSpeed = MMLEDSpin8->Value;
   MMSpectrum2->PeakSpeed = MMLEDSpin8->Value;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMLEDSpin5Change(TObject *Sender)
{
   MMSpectrum1->NumPeaks = MMLEDSpin5->Value;
   MMSpectrum2->NumPeaks = MMLEDSpin5->Value;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ckBShowPeakClick(TObject *Sender)
{
   MMSpectrum1->DisplayPeak = ckBShowPeak->Checked;
   MMSpectrum2->DisplayPeak = ckBShowPeak->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMLEDSpin6UpClick(TObject *Sender)
{
   MMSpectrum1->FrequencyScale = MMSpectrum1->FrequencyScale * 2;
   MMSpectrum2->FrequencyScale = MMSpectrum2->FrequencyScale * 2;
   MMLEDSpin6->Value = MMSpectrum1->FrequencyScale;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMLEDSpin6DownClick(TObject *Sender)
{
   MMSpectrum1->FrequencyScale = MMSpectrum1->FrequencyScale / 2;
   MMSpectrum2->FrequencyScale = MMSpectrum2->FrequencyScale / 2;
   MMLEDSpin6->Value = MMSpectrum1->FrequencyScale;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MMLEDSpin7Change(TObject *Sender)
{
   MMSpectrum1->RefFreq = MMLEDSpin7->Value;
   MMSpectrum2->RefFreq = MMLEDSpin7->Value;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ckBDrawDotedClick(TObject *Sender)
{
   MMSpectrum1->InactiveDoted = ckBDrawDoted->Checked;
   MMSpectrum1->ActiveDoted = ckBDrawDoted->Checked;
   if (MMSpectrum1->ActiveDoted) MMSpectrum1->Space = 2;
   else MMSpectrum1->Space = 1;
   MMSpectrum2->InactiveDoted = ckBDrawDoted->Checked;
   MMSpectrum2->ActiveDoted = ckBDrawDoted->Checked;
   if (MMSpectrum2->ActiveDoted) MMSpectrum2->Space = 2;
   else MMSpectrum2->Space = 1;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ckBDrawInactiveClick(TObject *Sender)
{
   MMSpectrum1->DrawInactive = ckBDrawInactive->Checked;
   MMSpectrum2->DrawInactive = ckBDrawInactive->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ckBLevelsClick(TObject *Sender)
{
   MMLevel1->Enabled = ckBLevels->Checked;
   MMLevel2->Enabled = ckBLevels->Checked;
}
//---------------------------------------------------------------------------



